using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace MojaPierwszaGraXNA
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        //trojkat
        private VertexPositionColor[] werteksyTrojkata = new VertexPositionColor[3]{
            new VertexPositionColor(new Vector3(0.5f, -0.5f, 0), Color.Cyan),
            new VertexPositionColor(new Vector3(-0.5f, -0.5f, 0), Color.Yellow),            
            new VertexPositionColor(new Vector3(0, 0.5f, 0), Color.Magenta)};
        //private BasicEffect efekt = null;
        private Effect efekt = null;
        Matrix World = Matrix.Identity, ViewProjection;
        
        //bufor
        VertexBuffer buforWerteksowTrojkata = null;

        /*
        //MessageBox via PInvoke
        [System.Runtime.InteropServices.DllImport("user32.dll", CharSet = System.Runtime.InteropServices.CharSet.Auto)]
        public static extern uint MessageBox(IntPtr hWnd, String text, String caption, uint type);            
        */

        public Game1()
        {
            Window.Title = "Modul 1. XNA - Szybki start: Podstawy teoretyczne";
            //Window.AllowUserResizing = true;

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferMultiSampling = true;
            graphics.PreparingDeviceSettings += new EventHandler<PreparingDeviceSettingsEventArgs>(graphics_PreparingDeviceSettings);
        }

        void graphics_PreparingDeviceSettings(object sender, PreparingDeviceSettingsEventArgs e)
        {
            //antyaliasing - mozna odblokowac na lepszych kartach graficznych
            //e.GraphicsDeviceInformation.PresentationParameters.MultiSampleQuality = 0;
            //e.GraphicsDeviceInformation.PresentationParameters.MultiSampleType = MultiSampleType.FourSamples;
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            this.IsMouseVisible = true;

            //efekt                        
            //efekt = new BasicEffect(graphics.GraphicsDevice, null);            
            //efekt.VertexColorEnabled = true;
        
            //bufor
            buforWerteksowTrojkata = new VertexBuffer(graphics.GraphicsDevice, VertexPositionColor.VertexDeclaration, werteksyTrojkata.Count(), BufferUsage.WriteOnly);
            buforWerteksowTrojkata.SetData<VertexPositionColor>(werteksyTrojkata);

            //odwieanie ustawie sceny            
            //this.TargetElapsedTime = TimeSpan.FromMilliseconds(13.333f);
            //this.TargetElapsedTime = TimeSpan.FromSeconds(1.0f/75.0f);
            this.IsFixedTimeStep = false;
            
            //pelny ekran
            /*
            try
            {                
                //graphics.PreferredBackBufferWidth = 800;
                //graphics.PreferredBackBufferHeight = 600;
                graphics.PreferredBackBufferWidth = graphics.GraphicsDevice.DisplayMode.Width;
                graphics.PreferredBackBufferHeight = graphics.GraphicsDevice.DisplayMode.Height;                
                graphics.IsFullScreen = true; //tylko w Windows  
                graphics.ApplyChanges();
                //alternatywnie:
                //graphics.ToggleFullScreen(); //tylko w Windows  
            }
            catch (Exception exc)
            {
                //MessageBox(new IntPtr(0), "Bd podczas przeczania w tryb penoekranowy:\n"+exc.Message, Window.Title, 16);
                System.Windows.Forms.MessageBox.Show("Bd podczas przeczania w tryb penoekranowy:\n"+exc.Message, Window.Title, System.Windows.Forms.MessageBoxButtons.OK,System.Windows.Forms.MessageBoxIcon.Error);
            }            
            */

            //macierz rzutowania                        
            //efekt.Projection = Matrix.CreateOrthographic(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 0.0f, 100.0f);
            //efekt.Projection = Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);
            //efekt.Projection = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver2,graphics.GraphicsDevice.Viewport.AspectRatio, 1.0f, 100.0f);            

            //kamera
            //efekt.View = Matrix.CreateTranslation(0, 0, -1);
            //efekt.View = Matrix.CreateLookAt(new Vector3(0, 0, 1), new Vector3(0, 0, 0), new Vector3(0, 1, 0));
            
            ViewProjection = 
                Matrix.CreateLookAt(new Vector3(0, 0, 1), new Vector3(0, 0, 0), new Vector3(0, 1, 0)) *
                Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver2, graphics.GraphicsDevice.Viewport.AspectRatio, 1.0f, 100.0f);
            
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            efekt = Content.Load<Effect>("efekt");            
            //efekt.Parameters["Kolor"].SetValue(new float[4] { 1, 1, 0, 1 });
            efekt.Parameters["Kolor"].SetValue(Color.White.ToVector4());
            efekt.Parameters["KopiujKolorWerteksu"].SetValue(false);
            efekt.Parameters["WorldViewProjection"].SetValue(World*ViewProjection);

            string parametry = "Parametry efektu: ";
            foreach (var parametr in efekt.Parameters)
                parametry += parametr.Name + " : " + parametr.Semantic + ";  ";
            this.Window.Title = parametry;
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            if (!this.IsActive) return;

            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //klawiatura
            if (Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Space)) graphics.ToggleFullScreen();            

            //przeksztalcenia
            Matrix macierzPrzeksztalcenia = Matrix.Identity;
            macierzPrzeksztalcenia *= Matrix.CreateScale(0.5f);
            //macierzPrzeksztalcenia *= Matrix.CreateRotationZ((float)-Math.PI / 2.0f);
            macierzPrzeksztalcenia *= Matrix.CreateRotationZ(-MathHelper.PiOver2);
            macierzPrzeksztalcenia *= Matrix.CreateTranslation(0.5f, 0, 0.0f);
            //efekt.World = macierzPrzeksztalcenia;

            //animacja
            //efekt.World *= Matrix.CreateRotationZ(gameTime.ElapsedRealTime.Milliseconds / 1000.0f);            

            World *= Matrix.CreateRotationZ(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);
            //efekt.Parameters["WorldViewProjection"].SetValue(World * ViewProjection);
            efekt.Parameters["faza"].SetValue((float)(gameTime.TotalGameTime.TotalMilliseconds / 80));

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            if (!this.IsActive) return;

            //graphics.GraphicsDevice.Clear(Color.CornflowerBlue);            

            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            gd.RasterizerState = RasterizerState.CullNone;

            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();

                //Instrukcje rysujace figury (prymitywy)
                //wersja bez bufora werteksw         
                //gd.DrawUserPrimitives<VertexPositionColor>(PrimitiveType.TriangleList, werteksyTrojkata, 0, 1);

                //wersja z buforem
                gd.SetVertexBuffer(buforWerteksowTrojkata);
                gd.DrawPrimitives(PrimitiveType.TriangleList, 0, 1);
            }

            base.Draw(gameTime);
        }
    }
}
